/*  readFileToDynamicMemory.c

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#include "decbutil.h"

#include "decbutil_private.h"


word
decbutil_readFileToDynamicMemory(byte driveNo, const char *filename,
                                 void *(*allocateMemory)(size_t *numSectors, unsigned long fileSizeInBytes, void *userData),
                                 void *userData)
{
    DECBDrive driveArray[1];
    unsigned long initReturnValue;

    word w = decbutil_init(driveArray, driveNo, &initReturnValue);
    if (DECBUTIL_ERR(w) != DECB_OK)
        return w;

    DECBFile file;
    byte err = decb_openSectorFile(&file, driveNo, filename);
    if (err != DECB_OK)
    {
        (void) decbutil_shutdown(initReturnValue);
        return STATUS(DECBUTIL_OPEN_SECTOR_FILE, err);
    }

    size_t numSectors;
    dword lengthInBytes;
    byte numGranules = decb_getOpenFileSize(&file, &numSectors, &lengthInBytes);
    word returnStatus = 0;
    if (numGranules == 0xFF)
        returnStatus = STATUS(DECBUTIL_GET_FILE_SIZE, DECB_ERR_NOT_FOUND);
    else
    {
        byte *memory = (byte *) (*allocateMemory)(&numSectors, lengthInBytes, userData);  // this may reduce numSectors
        if (memory == NULL)
            returnStatus = STATUS(DECBUTIL_ALLOCATE_MEMORY, err);
        else
            for (size_t fileSectorIndex = 0; fileSectorIndex < numSectors; ++fileSectorIndex, memory += 256)
            {
                err = decb_readSector(&file, memory, fileSectorIndex);
                if (err != DECB_OK)
                {
                    returnStatus = STATUS(DECBUTIL_READ_SECTOR, err);
                    break;
                }
            }
    }

    byte closeErr = decb_closeSectorFile(&file);

    word shutdownCode = decbutil_shutdown(initReturnValue);

    if (DECBUTIL_ERR(returnStatus) != DECB_OK)  // return pre-close error if any
        return returnStatus;
    if (closeErr != DECB_OK)
        return STATUS(DECBUTIL_CLOSE_SECTOR_FILE, err);
    if (DECBUTIL_ERR(shutdownCode) != DECB_OK)
        return shutdownCode;

    return STATUS(DECBUTIL_NONE, DECB_OK);
}
