/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_readRecord(DECBRecordFile *recFile, byte *record, word recordIndex)
{
    if (recordIndex >= recFile->numRecords)
        return DECB_ERR_NOT_FOUND;
    word sectorIndex;
    byte byteOffsetInSector;
    byte err = decb_getRecordOffsets(recFile, recordIndex, &sectorIndex, &byteOffsetInSector);
    if (err != DECB_OK)
        return err;
    word recordSizeToRead = recFile->recordSize;
    for (;;)
    {
        // Read a sector that contains the record, or part of the record.
        byte sectorBuffer[256];
        err = decb_readSector(&recFile->file, sectorBuffer, sectorIndex);
        if (err != DECB_OK)
            return err;
        // Copy the record, or part of the record, from the sector buffer.
        word roomInCurrentSector = 256 - byteOffsetInSector;
        byte isLastSectorOfRecord = (recordSizeToRead <= roomInCurrentSector);
        word memcpySize = (isLastSectorOfRecord ? recordSizeToRead : roomInCurrentSector);
        memcpy(record, sectorBuffer + byteOffsetInSector, memcpySize);
        if (isLastSectorOfRecord)
            break;
        byteOffsetInSector = 0;  // in next sector, start read at offset 0
        recordSizeToRead -= memcpySize;  // this much less is left to be read
        record += memcpySize;  // point to next part to be read in
        ++sectorIndex;  // next sector in file
    }
    return DECB_OK;
}
