/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_readSector(DECBFile *file,
                byte sectorBuffer[256],
                word fileSectorIndex)
{
    byte lastFileGranule;
    word numSectors;
    byte numGranulesInFile = decb_getNumGranulesInOpenFile(file, &lastFileGranule, &numSectors);
    if (numGranulesInFile == 0xFF)
        return DECB_ERR_CORRUPT_FAT;
    if (fileSectorIndex >= numSectors)
        return DECB_ERR_NOT_FOUND;
    byte fileGranIndex = (byte) (fileSectorIndex / 9);
    byte sectorIndexInGranule = (byte) (fileSectorIndex % 9);
    byte track, sector;
    byte err = decb_computeTrackAndSector(file, fileGranIndex, sectorIndexInGranule,
                                          &track, &sector);
    if (err != DECB_OK)
        return err;
    if (!decb_dskcon(DECB_DSKCON_READ, sectorBuffer, file->driveNo, track, sector))
        return DECB_ERR_IO;
    return DECB_OK;
}
