/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_rename(byte driveNo, const char *existingFilename, const char *newFilename)
{
    char normalizedExistingFilename[12];
    decb_normalizeFilename(normalizedExistingFilename, existingFilename);
    byte dirSectorBuffer[256];
    byte dirSectorNum, byteOffsetInDirSector;
    byte err = decb_findDirEntry(FALSE, driveNo, normalizedExistingFilename,
                                 dirSectorBuffer, &dirSectorNum, &byteOffsetInDirSector);
    if (err != DECB_OK)
        return err;
    DECBDirEntry *dirEntry = (DECBDirEntry *) (dirSectorBuffer + byteOffsetInDirSector);
    char normalizedNewFilename[12];
    decb_normalizeFilename(normalizedNewFilename, newFilename);
    memcpy(dirEntry->name, normalizedNewFilename, 11);
    if (!decb_dskcon(DECB_DSKCON_WRITE, dirSectorBuffer, driveNo, 17, dirSectorNum))
        return DECB_ERR_IO;
    return DECB_OK;
}
