/*  runDOSLoader.h - Moves and executes a loader program.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#ifndef _H_RUNDOSLOADER
#define _H_RUNDOSLOADER

#include <coco.h>


// Moves and executes a loader program that has just been loaded, typically by DECB's DOS command.
//
// loaderDestination: Address where the loader program must be moved, then executed.
//                    There must be 4608 bytes free at that location.
//                    That region must not overlap the 4608-byte region at 'loaderSource',
//                    which is where the track is moved from.
//                    Typically, a suitable location in low memory is 0x0600..0x17FF.
// loaderSource: Address where the loader program currently is. (Typically 0x2600.)
//               This region is assumed to be 4608 bytes long.
// newStackBottom: Address where to put the bottom of the stack during the loading phase
//                 and when jumping to the client program. Typically 0xFEEE on a 64k CoCo.
// executableFilename: 11-character filename (NUL-terminated), e.g., "FOOBAR  APP".
//                     Must be in drive 0.
//                     Must contain an executable in raw format, NOT in DECB's BIN format.
//                     Normally, that executable should have been compiled with CMOC's --raw option.
// clientProgramStart: Address where the client program (the actual app) must be loaded.
//                     The buffer where the app is loaded must not overlap the 4608-byte region
//                     at 'loaderSource'. A typical location is 0x1800.
//                     N.B.: The stack gets relocated just below $FEEE before jumping to this app.
// loadStartCallback: Function that is called when 'executableFilename' has been found in the directory.
//                    It receives the number of "steps" in the loading phase.
//                    This information can be used to display a progress indicator.
//                    Allowed to be null.
// progressCallback: Function that is called at each "step" of the loading phase.
//                   Will be called a number of times equal to the number of steps passed to loadStartCallback.
//                   Allowed to be null.
//
// Does not return upon success; instead jumps to clientProgramStart, with interrupts masked.
//
// Upon error, returns an error code, with interrupts unmasked:
//     1: The program specified by 'executableFilename' was not found (in drive 0).
//     2: The program was found but an error happened when trying to load it.
// At this point, the IRQ service routine will be private to this function.
// If the caller wants to use the IRQ in some way, it must install its own IRQ routine.
//
byte decbfile_runDOSLoader(void *loaderDestination,
                           const void *loaderSource,
                           void *newStackBottom,
                           const char *executableFilename,
                           void *clientProgramStart,
                           void (*loadStartCallback)(size_t numSteps),
                           void (*progressCallback)(void));


#endif  /* _H_RUNDOSLOADER */
