/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_setFATEntry(byte driveNo, byte entryIndex, byte newValue)
{
    if (entryIndex >= DECB_MAX_NUM_GRANULES)
        return DECB_ERR_INVALID_ARGUMENT;
    DECBDrive *drive = decb_getDrive(driveNo);
    if (!drive)
        return DECB_ERR_DRIVE_NOT_REGISTERED;
    drive->fatBuffer[entryIndex] = newValue;
    drive->fatNeedsSave = TRUE;
    return DECB_OK;
}
