/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_truncateOpenRecordFile(DECBRecordFile *recFile, word recordIndex)
{
    if (recordIndex >= recFile->numRecords)
        return DECB_OK;  // nothing to do
    word sectorIndex;
    byte byteOffsetInSector;
    byte err = decb_getRecordOffsets(recFile, recordIndex, &sectorIndex, &byteOffsetInSector);
    if (err != DECB_OK)
        return err;
    if (byteOffsetInSector == 0)
        err = decb_truncateOpenFile(&recFile->file, sectorIndex, 256);
    else
        err = decb_truncateOpenFile(&recFile->file, sectorIndex + 1, byteOffsetInSector);
    if (err != DECB_OK)
        return err;
    recFile->numRecords = recordIndex;
    return DECB_OK;
}
