/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_unregisterDrive(byte decbDriveNo)
{
    DECBDrive *drv = decb_getDrive(decbDriveNo);
    if (!drv)
        return DECB_ERR_DRIVE_NOT_REGISTERED;
    const DECBDrive *lastDrv = &decb_drives[decb_numRegisteredDrives - 1];
    if (drv != lastDrv)  // if not last element of array
    {
        // Move last element of array onto the one getting unregistered.
        *drv = *lastDrv;
    }
    --decb_numRegisteredDrives;
    return DECB_OK;
}
