/*  decbfile - A read/write DECB file library.

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.
*/

#include "decbfile_private.h"


byte
decb_writeFAT(byte driveNo)
{
    DECBDrive *drive = decb_getDrive(driveNo);
    if (!drive)
        return DECB_ERR_DRIVE_NOT_REGISTERED;
    if (!drive->fatLoaded)
        return DECB_ERR_FAT_NOT_LOADED;
    if (!drive->fatNeedsSave)
        return DECB_OK;
    char sectorBuffer[256];
    memcpy(sectorBuffer, drive->fatBuffer, DECB_MAX_NUM_GRANULES);
    memset(sectorBuffer + DECB_MAX_NUM_GRANULES, 0xFF, 256 - DECB_MAX_NUM_GRANULES);
    if (!decb_dskcon(DECB_DSKCON_WRITE, sectorBuffer, driveNo, 17, 2))
        return DECB_ERR_IO;
    drive->fatNeedsSave = FALSE;
    return DECB_OK;
}
