/*  writeMemoryToFile.c

    By Pierre Sarrazin <http://sarrazip.com/>
    This file is in the public domain.

    THERE IS NO WARRANTY AS TO THE RELIABILITY OF THIS LIBRARY.
    Users as advised to make BACKUPS of any file that might come into
    contact with this library.
*/

#include "decbutil.h"

#include "decbutil_private.h"


word
decbutil_writeMemoryToFile(byte driveNo, const char *filename,
                           const void *memory, size_t numSectors, BOOL isText)
{
    DECBDrive driveArray[1];
    unsigned long initReturnValue;

    word w = decbutil_init(driveArray, driveNo, &initReturnValue);
    if (DECBUTIL_ERR(w) != DECB_OK)
        return w;
    
    DECBFile file;
    byte err = decb_createSectorFile(&file, driveNo, filename,
                                     DECB_TYPE_BASIC_DATA,
                                     isText ? DECB_FORMAT_ASCII : DECB_FORMAT_BINARY);
    if (err != DECB_OK)
        return STATUS(DECBUTIL_CREATE_SECTOR_FILE, err);

    for (size_t fileSectorIndex = 0; fileSectorIndex < numSectors; ++fileSectorIndex, memory += 256)
    {
        err = decb_writeSector(&file, (const byte *) memory, fileSectorIndex);
        if (err != DECB_OK)
            return STATUS(DECBUTIL_WRITE_SECTOR, err);
    }

    // No need to call decb_setNumBytesUsedInLastSector(&file, 256) because
    // decb_closeSectorFile() will automatically set that number to 256.

    return decbutil_closeAndShutdown(&file, initReturnValue);
}
