/*
  Beyond The Tesseract   V2.0p   By David Lo :

    TRS-80 version 1.7 : 5/29/83  3/16/86 (Level II BASIC)
    MS-DOS version 2.0 : 9/1/88   10/1/88 (Turbo C 1.5)
*/

/*
    Portable version      V2.0p  By Dennis Lo  10/30/88

    This version can compile with Datalight C 2.20, Microsoft C 5.0,
    QuickC 1.0, Turbo C 1.5, Unix cc (SunOs 3.?), and GNU cc.

    - Changed ANSI-style function parameter declarations to K & R-style.
    - Removed #include <string.h> and added the string routines
      strlwr() and strchr() in parser.c so that it will compile with
      compilers that don't have them (like my Datalight C 2.20).
    - In ding(), split up the huge prints string into one prints()
      per line.
    - Moved the #include "parser.c" and "tess-def.c" to after the
      #include "conio.h"/#define printc code, because parser.c uses
      one cprintf().
    - Changed enumerations in tess-def.c to #defines because Unix cc
      insisted enums are not ints.
    - In main(), changed the tolower() call to a compare of both 'n' and
      'N' since tolower() doesn't work if the input is already in lower 
      case (only on Unix).
*/

/****** Define tty for 'dumb terminal' mode.  Else the 'full-screen' mode
        will use Turbo-C screen manipulation library routines.  ******/
#define tty


#include <ctype.h>
/*#include <string.h>*/
#include <stdio.h>

#define max(a,b) (((a) > (b)) ? (a) : (b))
#define min(a,b) (((a) < (b)) ? (a) : (b))

/*------------------------------------------------------------*/
/* on some PC clones (e.g. mine), scrolling the screen when printing a '\n'
   with the conio.h routines (e.g. putch('\n') or cprintf('\n')) is much slower
   than the stdio.h routines.
*/
nl()  {  putchar('\n');  }

/*----------------------------*/
int get_enter()
{
  int i=0, ch;

  while ((ch=getchar()) != '\n')
    i+=ch;
  return (i);
}

/*----------------------------*/
/* if tty-mode, then using standard library functions for I/O, and ignore the
   screen I/O functions
*/
#ifdef tty

#  define cprintf printf
#  define cputs printf
#  define prints puts

#  define clrscr()
#  define clreol()
# define gotoxy(x,y)

/* if non-tty-mode, use console IO library
*/
#else

#  include <conio.h>

  prints( s )
    char *s;
  {
    cputs( s );
    nl();
  }

#endif


#include "tess-def.c"
#include "parser.c"


/*------------------------------------------------------------*/
/* Adventure dependent stuff
*/

int
  print_room,         /* flag for updating room after command */

  curr_loc,           /* current location */
  curr_lev,           /* current level */
  level_loc [ 4 ],    /* current location for diff. levels */
  zap,                /* flag set when game over */
                      /*   1=quit   2=wrong password   3=right password */

  sleep_lev,          /* which level player was in when sleeping */

                      /* flags are 0=false/haven't done, 1=true/done */
                      /* unless otherwise noted */

  cc,                 /* coil status: 0=normal  b1=cooled  b2=magnetized */
  wa,                 /* water alien */
  ep,                 /* eat pills */
  dr,                 /* dice roll counter */
  af,                 /* audio filter inserted */
  gp,                 /* get password */
  mi,                 /* message: bits 0,1,2,3 = parts found */
  ti,                 /* think idea */
  kp,                 /* kick projector */

  dc [ 3 ],           /* each dice roll, dc[i]<33 */
  sum                 /* sum = sigma( dc ) < 100  */
  ;

/*----------------------------*/
InitAdv()
{
  int i;

  for ( i=1; i<MaxObjs; i++ )
  {
    obj[i].loc = obj[i].init_loc;
  }

  level_loc[1] = 2;
  level_loc[2] = 25;
  level_loc[3] = 29;

  curr_lev = 1;
  curr_loc = level_loc [ curr_lev ];

  zap = cc = wa = ep = dr = af = gp = mi = ti = kp = 0;

  for ( sum=0, i=0; i<3; i++ )
    sum += (dc [i] = rand() & 31);

  print_room = 1;
}

/*------------------------------------------------------------*/
/* Message routines
*/

/*----------------------------*/
PrintMess( i )
  int i;
{
  switch ( i )
  {
    case 1: prints("Nothing special happens."); break;
    case 2: prints("That isn't possible."); break;
    case 3: prints("Doesn't work."); break;
    case 4: prints("Can't do that yet."); break;
    case 5: prints("OK."); break;
    case 6: prints("How?"); break;
    case 7: cprintf("You have nothing to %s with.", cmd.verb ); nl(); break;
  }
}

not_happen() {  PrintMess( 1 );  }
not_poss()   {  PrintMess( 2 );  }
not_work()   {  PrintMess( 3 );  }
not_yet()    {  PrintMess( 4 );  }
ok()         {  PrintMess( 5 );  }
how()        {  PrintMess( 6 );  }

/*------------------------------------------------------------*/
/* Object routines
*/

/*----------------------------*/
int CheckObjAttr( nn, mask )
  int nn;
  int mask;
{
  return ( obj [nn].attr & mask );
}

#define CanGetObj(i) CheckObjAttr((i),1)
#define CanLookObj(i) CheckObjAttr((i),4)

/*----------------------------*/
CarryObj( nn )
  int nn;
{
  obj [nn].loc = -curr_lev;
}

int CarryingObj( nn )
  int nn;
{
  return ( obj [nn].loc == -curr_lev );
}

/*----------------------------*/
WearObj( nn )
  int nn;
{
  obj [nn].loc = -curr_lev - 3;
}
  
int WearingObj( nn )
  int nn;
{
  return ( obj [nn].loc == -curr_lev-3 );
}

/*----------------------------*/
int ObjOnPlayer( nn )
  int nn;
{
  return ( CarryingObj(nn) || WearingObj(nn) );
}

/*----------------------------*/
DropObj( nn )
  int nn;
{
  obj [nn].loc = curr_loc;
}

int ObjInRoom( nn )
  int nn;
{
  return ( obj [nn].loc == curr_loc );
}

/*----------------------------*/
JunkObj( nn )
  int nn;
{
  obj [nn].loc = 0;
}

/* replace object nn with object new_nn
*/
ReplaceObj( nn, new_nn )
  int nn;
  int new_nn;
{
  obj [new_nn].loc = obj [nn].loc;
  obj [nn].loc = 0;
}

/*----------------------------*/
/* See if an object is accessible.  This means the object is being
   carried/worn, is in the same room, is a concept noun (e.g. north),
   is part of the room (e.g. field), or is part of another object
   (e.g. button).
*/
int ObjIsPresent( nn )
  int nn;
{
  if ( (nn>=o_north) && (nn<=o_invent) ) /* direction, "inventory" */
    return (1);               /* always available */

  else if ( (nn>=o_buttons) && (nn<=o_four) )  /* buttons */
    return ( ObjIsPresent(o_proj) );           /* on projector */

  else if ( (nn==o_liquid) && (obj[nn].loc==-8) )  /* contained fluid */
    return ( ObjIsPresent(o_bottle) );             /* in Klein bottle */

  else
    return ( ObjInRoom(nn) || CarryingObj(nn) || WearingObj(nn) );
}

/*------------------------------------------------------------*/
/* Room routines
*/

/*----------------------------*/
/* predicates to return check whether the player in in a certain world
*/
int InComplex( rn )
  int rn;
{
  return ( rn==1 || rn==2 || rn==7 || rn==8 );
}

int InMirrorWorld( rn )
  int rn;
{
  return ( rn==4 || (rn>=9 && rn<=13) );
}

int InMathWorld( rn )
  int rn;
{
  return ( rn==3 || rn==5 || (rn>=14 && rn<=17) );
}

int InSpectralWorld( rn )
  int rn;
{
  return ( rn==6 || (rn>=18 && rn<=22) );
}

int InDreamWorld( rn )
  int rn;
{
  return ( curr_lev==2 || (rn>=23 && rn<=28) || rn==35 );
}

int InBookWorld( rn )
  int rn;
{
  return ( curr_lev==3 || (rn>=29 && rn<=34) );
}

/*----------------------------*/
PrintCurrRoom()
{
  int i,flag, len,currx;
  char *s;

#ifndef tty
  static int stop_line=1;
  /* clear window area from previous time
  */
  for ( i=stop_line; i>=1; i-- )
  {
    gotoxy( 1, i );
    clreol();
  }
#endif

  cprintf("You are %s.", room [ curr_loc ].name ); nl();

  prints("You see around you:");
  clreol();
  flag=0;
  currx=0;
  for ( i=1; i<MaxObjs; i++ )
    if (ObjInRoom(i))
    {
      s = obj[i].name;
      len = strlen(s);
      if (currx+ len + 3 > 78 ) { currx=0; nl(); clreol(); }
      cprintf("  %s.", s );
      currx += len+3;
      flag=1;
    }
  if (!flag)
    prints("  Nothing special.");
  else
    { nl(); clreol(); }

  prints("Exits:");
  clreol();
  flag=0;
  for ( i=0; i<MaxDirs; i++ )
    if ( room [curr_loc].link [i] )
    {
      cprintf("  %s.", obj[i+1].name );
      flag=1;
    }
  if (!flag) cprintf("  none.");
  nl();

#ifdef tty
  nl();
#else
  prints
("__________________________________________________________________________");
  stop_line = wherey();  /* stop line is the line after the separator bar */
  gotoxy( 1,25 );
#endif
}

/*----------------------------*/
goto_new_lev( lev )
  int lev;
{
  curr_lev = lev;
  curr_loc = level_loc [curr_lev];
}
  
goto_new_loc( rn )
  int rn;
{
  curr_loc = rn;
  level_loc [curr_lev] = curr_loc;
}

/*------------------------------------------------------------*/
/* Verb routines
*/

/*----------------------------*/
do_go()
{
  int direct, new_room;

  switch ( cmd.nn )
  {
    case o_north:
    case o_east:
    case o_south:
    case o_west:
      direct = cmd.nn - 1;                       /* assumes NESW = 1234 */
      new_room = room [curr_loc].link [direct];
      if (new_room)
      {
        goto_new_loc( new_room );
        print_room = 1;
      }
      else
        prints("Can't go in that direction");
      break;

    default:
/*
      if (isdigit(cmd.noun[0]))
      {
        new_room = atoi( cmd.noun );
        if ( (new_room>=0) && (new_room<MaxLocs) )
          goto_new_loc( new_room );
        else
          prints("Can't go there");
      }
      else
*/
        prints("Use a direction or the stack");
  }
}

/*----------------------------*/
do_dir()
{
  cmd.nn = cmd.vn;
  cmd.vn = 6;
  do_go();
}

/*----------------------------*/
do_inv()
{
  int flag, i, len,currx;
  char s[80];

  prints("You are carrying:");
  flag=0;
  currx=0;
  for ( i=1; i<MaxObjs; i++ )
    if ( ObjOnPlayer(i) )
    {
      strcpy( s, obj[i].name );
      if (WearingObj(i)) strcat( s, " (wearing)" );
      len = strlen(s);
      if (currx+ len + 3 > 78 ) { currx=0; nl(); }
      cprintf("  %s.", s );
      currx += len+3;
      flag=1;
    }

  if (!flag)
    prints("  nothing.");
  else
    nl();
}

/*----------------------------*/
do_get()
{
  int where, attr, i, get_flag;
  char s[16], *p;

  if (ObjOnPlayer(cmd.nn))
    prints("You already have it.");

  else if (cmd.nn==o_invent)      /* get everything in room */
  {
    for ( i=o_invent+1; i<MaxObjs; i++ )
      if ( ObjInRoom(i) && CanGetObj(i) )
      {
        cmd.nn=i;
        cprintf( "--> get %s", obj[i].name ); nl();
        do_get();
      }
  }

  else if (!CanGetObj(cmd.nn))      /* un-gettable object? */
  {
    if (cmd.nn==o_plant)    /* alien */
      prints("The being is rooted in the 4th dimension.");

    else if (cmd.nn==o_group)
      prints("The group has infinitely many reasons to stay where it is.");

    else if (cmd.nn==o_fluid)   /* fluid */
      prints("It's too cold!");

    else
      prints("Can't get that.");
  }

  else  /* gettable object */
  {
    get_flag = 1;

    if (cmd.nn==o_liquid)   /* 4-D liquid */
    {
      how();
      get_flag = 0;
    }

    else if (cmd.nn==o_plasma)   /* plasma */
    {
      if (!CarryingObj(o_coil) || (cc!=3))
      /* not have coil or not mag. bottle */
      {
        prints("Too hot to handle.");
        get_flag = 0;
      }
      else
        prints( "The magnetic field of the coil contained the plasma." );
    }

    else if (cmd.nn==o_improb)   /* improbability */
    {
      cprintf("What is the probability of getting this improbability? ");
      getline( s, sizeof(s) );
      p = strchr( s, '.' );  /* skip past decimal point */
      if (p) p++;
      i = atoi( p );
      if (i!=sum && i*10!=sum)
      {
        prints("Wrong.");
        get_flag = 0;
      }
    }

    if (get_flag)
    {
      CarryObj( cmd.nn );
      ok();
    }
  }
}
  
/*----------------------------*/
do_drop()
{
  int where, i;

  if (ObjInRoom(cmd.nn))
    prints("It's already here.");

  else if (cmd.nn==o_improb && curr_loc==16)
    do_throw();

  else if (cmd.nn==o_invent)        /* drop everything */
  {
    for ( i=o_invent+1; i<MaxObjs; i++ )
      if ( ObjOnPlayer(i) )
      {
        cmd.nn=i;
        cprintf( "--> drop %s", obj[i].name ); nl();
        do_drop();
      }
  }

  else if (cmd.nn>o_invent)
  {
    if (cmd.nn==o_coil)  /* drop coil, check for plasma as well */
    {
      if (CarryingObj(o_coil) && CarryingObj(o_plasma))
        DropObj( o_plasma );
    }

    if ( ObjOnPlayer( cmd.nn ))
    {
      DropObj(cmd.nn);
      ok();
    }
  }
}

/*----------------------------*/
do_throw()
{
  char *s;

  if (ObjInRoom(cmd.nn))
    prints("It's already here.");

  else if (cmd.nn==o_improb && curr_loc==16)
  {
    prints("The improbability's presence warps the fabric of the field.");
    room [16].link [east] = 17 - room [16].link [east];
    print_room = 1;
    DropObj( cmd.nn );
  }
  else if (cmd.nn==o_cube)
    do_roll();

  else if (cmd.nn==o_disk)
  {
    prints
    ("With great skill (i.e. luck) you threw the disk into the next room.");
    if (curr_loc==29)
      obj [cmd.nn].loc = -7;
    else
      obj [cmd.nn].loc = room [curr_loc].link [south];
  }

  else
    do_drop();
}

/*----------------------------*/
do_break()
{
  if (cmd.nn==o_prism)
  {
    prints("The prism shatters along the lines and mysteriously");
    prints("reorganizes itself into a tetrahedron.");
    ReplaceObj( cmd.nn, o_tetra );
  }

  else if (cmd.nn==o_tetra)
    prints("It shatters, but quickly reforms itself.");

  else if (cmd.nn==o_zeta)
    do_solve();

  else if (cmd.nn==o_proj)
  {
    if (!kp)
    {
      prints
      ("With a few kicks and blows, both you and the projector felt better.");
      kp = 1;
    }
    else
      prints("Better not try that again, or you'll really break it.");
  }

  else
    prints("Violence is not necessary, most of the time.");
}

/*----------------------------*/
do_look()
{
  if (!cmd.nn)
    print_room = 1;

  else if (!CanLookObj(cmd.nn))
  {
    cprintf("Looks like %s.", obj[cmd.nn].name );  nl();
  }

  else
  switch ( cmd.nn )
  {
    case o_mirror:
      prints("You see the reflections of a mirror world.");
      break;

    case o_crt:
      prints("You see the images of a mathematical universe.");
      break;

    case o_group:
      prints("The group consists of converging parallel lines, alef-null,");
      prints("the last prime number, 1/0, and uncountably many others.");
      break;

    case o_hole:
      prints("You see the lights of an electromagnetic continuum.");
      break;

    case o_proj:
      prints("You see a wide slot and 5 buttons.");
      if (obj[o_disk].loc==-7)
        prints("A disk is in the projector.");

    case o_buttons:
      prints("The buttons are labelled zero to four.");
      break;

    case o_chaos:
      prints("It bears a slight resemblence to the current universe.");
      break;

    case o_dust:
      prints("It look like the remains of an exploded Julia set.");
      break;

    case o_flake:
      prints("It doesn't look like the coastline of Britain.");
      break;

    case o_mount:
      prints("It looks the same at all scales.");
      break;

    case o_tomb:
      prints("The epitaph reads: The Eternal Soul");
      mi = mi | 1;
      break;

    case o_stack:
      prints("It's a Space-Time Activated Continuum Key.");
      break;

    case o_audio:
      prints("Looks like 2 speakers connected by a band.");
      if (!af)
        prints("There is a groove in the band.");
      break;

    case o_book:
      prints("The title is 'Interactive Adventures'.");
      break;

    case o_bottle:
      if (obj[o_liquid].loc==-8)
        prints("It is full of some strange liquid.");
      else
        prints("It is an empty bottle with no inside or outside.");
      break;

    case o_prism:
      prints("You see flashes along deeply etched lines");
      if (curr_loc==21)
        prints("And embedded, distorted shapes resembling letters");
      break;

    case o_appa:
      prints("Looks like a device used for increasing the dimensions of");
      prints("geometric and topological objects.");
      break;

    case o_improb:
      prints("It looks like a heart of gold.");
      break;

    case o_zeta:
      prints("It's a very vicious-looking integral.");
      break;

    case o_cube:
      prints("There are changing numbers on the sides.");
      break;

    case o_coil:
      prints("The ends of the coil are connected to form a loop.");
      break;

    case o_sing:
      prints("It is shaped like a narrow band.");
      break;

    case o_disk:
      prints("The title is: The Science and Beauty of a Geometric Nature");
      break;

    case o_supp:
      prints("It's an almost obvious fact.");
      prints("It is not proven.");
      break;

    case o_hypo:
      prints("It's a complicated statement.");
      prints("It is not proven.");
      break;

    case o_lemma:
      prints("It's a rather specialized fact.");
      break;

    case o_theorem:
      prints("It begins: The metaphysical existentialism of reality ...");
      prints("The rest is incomprehensible to you.");
      break;

    case o_axiom:
      prints("It's the basis of a complex system.");
      break;

    case o_post:
      prints("It's a basic fact.");
      break;

    case o_math:
      prints("He looks almost asleep.");
      break;

    case o_tetra:
      if (curr_loc==22)
      {
        prints("Sharp letters form the message: Seeks the Exact");
        mi = mi | 2;
      }
      else
        prints("You see colorless letters.");
      break;

    case o_func:
      prints
      ("The function has many sharp points, all of which are at (1/2+bi).");
      break;

    case o_idea:
      prints("The idea is very vague and not fully developed.");
      break;

    case o_contra:
      prints
      ("It is true and false, but neither is correct, and both are right.");
      break;

    case o_warr:
      prints("It has expired.");
      break;

    default:
      cprintf("Looks like %s.", obj[cmd.nn].name );  nl();
  }
}

/*----------------------------*/
do_read()
{
  if (cmd.nn==o_book)
  {
    prints("You are now reading an adventure ...");
    goto_new_lev( 3 );
    print_room = 1;
  }
  else
    do_look();
}

/*----------------------------*/
do_use()
{
  switch ( cmd.nn )
  {
    case o_proj:
      prints("Try the buttons.");
      break;

    case o_stack:
      prints("Try push or pop the stack, or scan something with it.");
      break;

    case o_prism:
      do_look();
      break;

    case o_appa:
      prints("Try to _y_ something with it");
      break;

    case o_improb:
      if (curr_loc==16) do_throw(); else how();
      break;

    default:
      how();
      break;
  }
}

/*----------------------------*/
do_touch()
{
  cprintf( "Feels just like a %s.", cmd.noun );  nl();
}

/*----------------------------*/
do_swing()
{
  if (cmd.nn==o_coil)
    do_spin();
  else
    not_happen();
}

/*----------------------------*/
do_rub()
{
  do_touch();
}

/*----------------------------*/
do_push()
{
  int new_room;

  if (cmd.nn==o_stack)
  {
    if (curr_loc>3)
      not_happen();
    else if (gp)
      do_scan();
    else
    {
      prints("You are falling inwards ...");
      goto_new_loc( curr_loc+3 );
      print_room = 1;
    }
  }

  else if (obj[cmd.nn].loc==-7)
  {
    if (obj[o_disk].loc!=-7)
      not_happen();
    else if (!kp)
      prints("The projector begins to start, fizzes and grinds, then stops.");
    else
    {
      clrscr();
      gotoxy( 1,25 );
      prints("The lights dimmed for a while.");
      new_room = cmd.nn + 17;
      goto_new_loc( new_room );
      room [29].link [north] = curr_loc;
      print_room = 1;
      DropObj( o_proj );

      if (new_room==30)
      {
        prints("The projector ejects the disk.");
        DropObj( o_disk );
      }
    }
  }

  else
    not_happen();
}

/*----------------------------*/
do_pop()
{
  char *s;

  s = "You are falling outwards ...";

  if (gp)
    do_scan();

  else if (cmd.nn==o_pills)
    do_eat();

  else if (cmd.nn!=o_stack)
    not_poss();

  else if (InComplex( curr_loc ))
    prints("Can't transcend reality in this adventure.");

  else if (InMirrorWorld( curr_loc ))
  {
    goto_new_loc( 1 );
    print_room = 1;
    prints( s );
  }

  else if (InMathWorld( curr_loc ))
  {
    goto_new_loc( 2 );
    print_room = 1;
    prints( s );
  }

  else if (InSpectralWorld( curr_loc ))
  {
    goto_new_loc( 3 );
    print_room = 1;
    prints( s );
  }

  else
    not_happen();
}

/*----------------------------*/
do_spin()
{
  if (cmd.nn==o_coil)
  {
    if (curr_loc==18)
    {
      cc = cc | 2;
      ok();
    }
    else
      not_happen();
  }

  else
    not_happen();
}

/*----------------------------*/
do_roll()
{
  int n;

  if (cmd.nn==o_cube)
  {
    n = dr % 4;
    cprintf("You rolled a ");
    if (n<3)
      cprintf("%d.", dc[n]);
    else
      cprintf("+nnn.");
    nl();
    dr++;
  }
  else
    not_happen();
}

/*----------------------------*/
do_wear()
{
  if (WearingObj(cmd.nn))
    prints("You're already wearing it.");

  else if (cmd.nn==o_audio)
  {
    WearObj( cmd.nn );
    ok();
  }

  else
    not_poss();
}

/*----------------------------*/
do_eat()
{
  if (cmd.nn==o_plant)
    prints("Don't consume higher lifeforms.");

  else if (cmd.nn==o_pills)
  {
    prints("Gulp!  Suddenly you feel a little drowsy.");
    ep=1;
    JunkObj( cmd.nn );
  }

  else
    prints("Can't eat that.");
}

/*----------------------------*/
do_taste()
{
  switch ( cmd.nn )
  {
    case o_pills:
      prints("It tastes like a drug.");
      break;

    case o_solid:
    case o_liquid:
      prints("The taste is quite orthogonal.");
      break;

    default:
      prints("Can't taste that.");
      break;
  }
}

/*----------------------------*/
do_drink()
{
  if (cmd.nn==o_fluid)
    prints("Too cold.");

  else if (cmd.nn==o_liquid)
    prints("You're too low dimensioned to drink it.");

  else
    prints("Can't drink that.");
}

/*----------------------------*/
do_remove()
{
  if (!WearingObj(cmd.nn))
    prints("You are not wearing it.");

  else
  {
    CarryObj( cmd.nn );
    ok();
  }
}

/*----------------------------*/
do_water()
{
  if ( !ObjIsPresent(o_liquid) &&
       (!CarryingObj(o_bottle) || obj[o_liquid].loc!=-8) )
    prints("Nothing to water with.");

  else if (cmd.nn!=o_plant)
    prints("Can't water that.");

  else
  {
    prints("Dendrites appear from hyperspace and absorbed the liquid.");
    prints("The being thanks you.");
    wa = 1;
    JunkObj( o_liquid );
  }
}

/*----------------------------*/
do_fill()
{
  if (cmd.nn==o_bottle)
  {
    if (curr_loc==obj[o_liquid].loc)
    {
      obj[o_liquid].loc = -8;
      ok();
    }
    else if (curr_loc==obj[o_fluid].loc)
      prints("The fluid flows in and then flows out by itself");
  }

  else
    how();
}

/*----------------------------*/
do_pour()
{
  if (cmd.nn==o_bottle || cmd.nn==o_liquid)
  {
    if (obj[o_liquid].loc!=-8)
      prints("Nothing to pour.");

    else if (curr_loc==obj[o_plant].loc)
    {
      cmd.nn=o_plant;
      do_water();
    }

    else
    {
      DropObj( o_liquid );
      ok();
    }
  }

  else
    not_work();
}

/*----------------------------*/
do_freeze()
{
  if (curr_loc!=obj[o_fluid].loc)
    not_yet();

  else if (cmd.nn==o_coil)
  {
    cc = cc | 1;
    ok();
  }

  else
    prints("You might damage it.");

}

/*----------------------------*/
do_melt()
{
  if (!ObjIsPresent(o_plasma))
    not_yet();

  else if (cmd.nn==o_solid)
  {
    prints
    ("The plasma dissipates as the solid melts into a puddle of liquid.");
    JunkObj( o_plasma );
    JunkObj( o_solid );
    DropObj( o_liquid );
    if (curr_loc==obj[o_plant].loc)
    {
      cmd.nn=o_plant;
      do_water();
    }
  }

  else if (cmd.nn==o_tetra)
    prints("It melts, but quickly recrystalizes.");

  else
    not_work();
}

/*----------------------------*/
do_play()
{
  if (cmd.nn==o_cube)
    do_roll();

  else if (cmd.nn==o_disk)
    prints("You need something to play it.");

  else if (cmd.nn==o_proj)
    do_use();

  else
    not_happen();
}

/*----------------------------*/
do_insert()
{
  v_word noun;
  int nn;

  if (cmd.nn==o_sing)
  {
    nn = InputNoun( "Where? ", noun );
    if ( (!strcmp(noun,"groo") || !strcmp(noun,"band") || nn==o_audio)
         && ObjIsPresent(o_audio) )
    {
      af = 1;
      JunkObj( cmd.nn );
      prints("The singularity slides in with a click.");
    }
    else
      not_work();
  }

  else if (cmd.nn==o_disk)
  {
    nn = InputNoun( "Where? ", noun );
    if ( (!strcmp(noun,"slot") || nn==o_proj) && ObjIsPresent(o_proj) )
    {
      obj[cmd.nn].loc = -7;
      ok();
    }
    else
      not_work();
  }

  else
    not_work();
}

/*----------------------------*/
do_fix()
{
  if (cmd.nn==o_proj)
    prints("You don't know how to properly fix such a delicate instrument.");

  else
    prints("You don't know how.");
}

/*----------------------------*/
do__y_()
{
  if (!ObjIsPresent(o_appa))
    PrintMess( 7 );

  else switch ( cmd.nn )
  {
    case o_cube:
      if (dr<3)
        prints("You shouldn't do that yet.");
      else
      {
        prints("The hexahedron expands one dimension.");
        ReplaceObj( cmd.nn, o_solid );
      }
      break;

    case o_tetra:
      prints("It expands a dimension, but quickly collapses back.");
      break;

    case o_strip:
      prints("The moebius strip expands one dimension.");
      ReplaceObj( cmd.nn, o_bottle );
      break;

    case o_prism:
      prints("Object too unstable.");
      break;

    case o_bottle:
    case o_solid:
    case o_liquid:
      prints("Can't go any higher in this universe.");
      break;

    case o_appa:
      prints("Sorry, can't upgrade a product this way.");
      break;

    case o_plant:
      prints("The being is already high enough.");
      break;

    default:
      not_happen();
  }
}

/*----------------------------*/
do_prove()
{
  v_word noun;
  char *msg1;
  int nn;

  msg1 = "Somehow a contradiction keeps coming into the proof.";

  switch ( cmd.nn )
  {
    case o_lemma:
    case o_theorem:
    case o_axiom:
    case o_post:
      prints("It's already proven.");
      break;

    case o_supp:
      nn = InputNoun( "With what? ", noun );
      if (nn==o_post && ObjIsPresent(o_post))
      {
        if (ObjIsPresent(o_contra))
          prints( msg1 );
        else
        {
          prints("The postulate is now a lemma.");
          ReplaceObj( cmd.nn, o_lemma );
        }
      }
      else
        not_work();
      break;

    case o_hypo:
      nn = InputNoun( "With what? ", noun );
      if (nn==o_lemma && ObjIsPresent(o_lemma) && ObjIsPresent(o_axiom))
      {
        if (ObjIsPresent(o_contra))
          prints( msg1 );
        else
        {
          prints("The hypothesis is now a theorem.");
          ReplaceObj( cmd.nn, o_theorem );
          prints("Suddelnly, a hyper-spatial cliff passes by");
          prints("and the lemma leaps to its demise.");
          JunkObj( o_lemma );
        }
      }
      else
        prints("Hmmm, something seems to be missing from the proof.");
      break;

    case o_idea:
      prints("The idea developed into a contradiction.");
      ReplaceObj( cmd.nn, 52 );
      break;

    case o_contra:
      prints("You proved that the contradiction can't be proven.");
      break;

    default:
      not_poss();
  }
}

/*----------------------------*/
do_smell()
{
  prints("You smell nothing unusual.");
}

/*----------------------------*/
do_close()
{
  not_poss();
}

/*----------------------------*/
do_open()
{
  not_poss();
}

/*----------------------------*/
do_stop()
{
  if (!strcmp(cmd.sh_noun,"slee") || !strcmp(cmd.sh_noun,"drea"))
    do_wake();

  else if (!strcmp(cmd.sh_noun,"read"))
  {
    if (InBookWorld( curr_loc ))
    {
      goto_new_lev( 1 );
      print_room = 1;
      ok();
    }
    else
      prints("Reality is like a book that you can't stop reading.");
  }
  else
    not_work();
}

/*----------------------------*/
do_say()
{
  cprintf( "'%s'", cmd.noun ); nl();
  if (gp==0)
    not_happen();

  else
  {
    if (strcmp( cmd.noun,"tesseract" ))
      zap = 2; /* wrong password */
    else
      zap = 3; /* right password */
  }
}

/*----------------------------*/
do_quit()
{
  do_score();
  zap = 1;
}

/*----------------------------*/
do_help()
{
  if (cmd.nn>0)
    how();

  else if (curr_lev==2)
    prints("Use 'wake' to wake up from your dream.");

  else if (curr_lev==3)
    prints("Use 'stop reading' to stop reading the adventure.");

  else
    prints("Sorry, quasi-hyper-neo-mathematics is beyond me.");
}

/*----------------------------*/
do_listen()
{
  char *msg;

  msg = "Of Countless Tesseracts";

  if (curr_loc==19)
    prints("Sounds like radio waves from the Creation.");

  else if (curr_loc!=obj[o_plant].loc)
    prints("You hear nothing special.");

  else if (wa==0)
    prints("The being is whispering too softly.");

  else if (!WearingObj(o_audio))
    prints("You hear a harmonic song in a strange language.");

  else if (!af)
  {
    cprintf("You hear an %d00-voiced fugue in a complex 1/f melody.", sum);
    nl();
    prints("But you are unable to follow even a single voice.");
  }

  else
  {
    cprintf("You hear the words: %s.", msg );  nl();
    mi = mi | 8;
  }
}

/*----------------------------*/
do_save()
{
  int i;
  FILE *f;
  char s[80];

  cprintf("Filename to save game to: ");
  getline( s, sizeof(s) );
  if (!*s) return;

  f=fopen(s,"w");
  if (f)
  {
    for ( i=1; i<MaxObjs; i++ )
      fprintf( f, "%d ", obj[i].loc );

    fprintf( f, "%d %d %d %d %d %d ",
      curr_lev, curr_loc,
      level_loc[1], level_loc[2], level_loc[3], sleep_lev );

    fprintf( f, "%d %d %d %d %d %d %d %d %d %d %d %d ",
      cc, wa, ep, dr, af, gp, mi, ti, kp, dc[0], dc[1], dc[2] );

    putc( '\n', f );
    fclose( f );
    prints("Game saved.");
  }
  else
  {
    cprintf("Unable to save game to %s", s); nl();
  }
}

/*----------------------------*/
do_load()
{
  int i;
  FILE *f;
  char s[80];

  cprintf("Filename to load game from: ");
  getline( s, sizeof(s) );
  if (!*s) return;

  f=fopen(s,"r");
  if (f)
  {
    for ( i=1; i<MaxObjs; i++ )
      fscanf( f, "%d ", &obj[i].loc );

    fscanf( f, "%d %d %d %d %d %d ",
      &curr_lev, &curr_loc,
      &level_loc[1], &level_loc[2], &level_loc[3], &sleep_lev );

    fscanf( f, "%d %d %d %d %d %d %d %d %d %d %d %d ",
      &cc, &wa, &ep, &dr, &af, &gp, &mi, &ti, &kp, &dc[0], &dc[1], &dc[2] );

    for ( sum=0, i=0; i<3; i++ )
      sum += dc[i];

    fclose( f );
    prints("Game loaded.");
    print_room = 1;
  }
  else
  {
    cprintf("Unable to load game from %s", s); nl();
  }
}

/*----------------------------*/
do_score()
{
  cprintf("You scored %d out of 15.", mi );  nl();
}

/*----------------------------*/
do_sleep()
{
  if (InDreamWorld( curr_loc ))
  {
    prints("A dream within a dream would have been quite poetic,");
    prints("But time did not allow for it.");
  }

  else if (ep==0)
    prints("You're not sleepy yet.");

  else
  {
    prints("As you sleep, you begin to have a strange dream ...");
    sleep_lev = curr_lev;
    goto_new_lev( 2 );
    print_room = 1;
  }
}

/*----------------------------*/
do_wake()
{
  if (cmd.nn!=o_math && cmd.nn>0)
    not_work();

  else if (!InDreamWorld( curr_loc ))
    prints("Reality is not a fragment of nightmares and dreams.");

  else if (cmd.nn!=o_math)
  {
    prints("Wow, that was some dream.");
    goto_new_lev( sleep_lev );
    print_room = 1;
  }

  else
  {
    if (!ObjInRoom(o_theorem))
      prints
      ("He mumbles: bother me not, I'm contemplating the ultimate question");
    else
    {
      prints("He wakes up, looks at the theorem, an shouts:");
      prints("Eureka!  This proves that the universe doesn't exis...");
      goto_new_loc( 35 );
      print_room = 1;
      mi = mi | 4;
    }
  }
}

/*----------------------------*/
do_give()
{
  int nn;
  v_word noun;

  nn = InputNoun( "To whom? ", noun );
  if (!nn)
    not_work();

  else if (!ObjIsPresent(nn))
    not_yet();

  else if (nn==o_math)
  {
    if (cmd.nn==o_theorem)
    {
      DropObj( cmd.nn );
      cmd.nn=o_math;
      do_wake();
    }
    else
      prints("He mumbles: disturb me not with such unimportant things.");
  }

  else if (nn==o_plant)
  {
    if (cmd.nn==o_liquid)
      how();
    else if (cmd.nn==o_solid)
      prints("Plants don't eat solid nutrients.");
    else
      prints("The being doesn't need that.");
  }

  else
    not_work();
}

/*----------------------------*/
int stack_say( s )
  char *s;
{
  cprintf("Stack: ");
  if (*s) prints( s );
  return( 1 );
}

do_scan()
{
  char *s;
  int flag;

  s = "stack potential non-zero, pushing allowed.";
  flag = 0;

  if (!ObjOnPlayer(o_stack))
    PrintMess( 7 );

  else if (gp)
  {
    prints("Something has rendered the stack inoperative.");
    return;
  }

  else if (cmd.nn==0)
  {
    if (InMirrorWorld( curr_loc ) || InMathWorld( curr_loc ) ||
        InSpectralWorld( curr_loc ))
      flag = stack_say("stack level non-zero, popping allowed.");

    if (curr_loc<=3)
      flag = stack_say( s );

    if (curr_loc==18)
      flag = stack_say("magnetic field present.");

    if (curr_loc==obj[o_plant].loc)
      flag = stack_say("sonic harmony present.");

    if (!flag)
      stack_say("nothing special to report.");
  }

  else
  {
    stack_say( "" );
    switch ( cmd.nn )
    {
      case o_mirror:
      case o_crt:
      case o_hole:
        prints( s );
        break;

      case o_plant:
        cprintf("4-D.  ");
        if (!wa)
          prints("dehydrated.  weak audio output.");
        else
          prints("healthy.  strong audio output.");
        break;

      case o_stack:
        prints("Stack operational.");
        break;

      case o_audio:
        if (!af)
          prints("no filter.");
        else
          prints("filter active.");
        break;

      case o_pills:
        prints("edible.  barbiturate.");
        break;

      case o_fluid:
        prints("extremely cold.  superconductive.  superfluid.");
        break;

      case o_prism:
        prints("brittle.  light sensitive.");
        break;

      case o_coil:
        prints("composition = yttrium, barium, copper, oxygen.");
        if (cc)
        {
          cprintf("Stack: properties = ");
          if (cc & 1) cprintf("superconductive.  ");
          if (cc & 2) cprintf("magnetic.  ");
          if ((cc & 3)==3) cprintf("strong magnetic field present.");
          nl();
        }
        break;

      case o_plasma:
        prints("extremely hot.");
        break;

      case o_solid:
        prints("4-D.  solid.");
        break;

      case o_liquid:
        prints("4-D.  liquid.");
        break;

      case o_tetra:
        prints("color sensitive.  omni-stable.");
        break;

      default:
        prints("nothing special to report.");
        break;

    } /* switch */
  } /* else */
}

/*----------------------------*/
do_solve()
{
  int nn;
  v_word noun;

  if (cmd.nn==o_zeta)
  {
    nn = InputNoun("With what? ", noun );
    if (!nn)
      not_work();

    else if (!ObjIsPresent(nn))
      not_yet();

    else if (nn!=o_func)
      prints
      ("Not difficult, although for someone like you it's too still hard.");

    else
    {
      prints("The function and the integral cancel out nicely");
      prints("and everything is reduced to a singularity.");
      ReplaceObj( cmd.nn, o_sing );
      JunkObj( o_func );
    }
  }

  else if (cmd.nn==o_func)
    prints("You are not really into great episodes of frustration.");

  else if (cmd.nn==o_improb)
    prints("It's improbable that you can solve it.");

  else
    not_work();
}

/*----------------------------*/
do_think()
{
  if (!InDreamWorld(curr_loc))
    prints("Therefore you are.");

  else if (curr_loc!=25)
    prints("This is not a good place to think.");

  else if (!ti)
  {
    prints("You thought of an idea.");
    CarryObj( o_idea );
    ti = 1;
  }

  else
    prints("You are out of ideas.");
}

/*----------------------------*/
do_burn()
{
  if (!ObjIsPresent(o_plasma))
    not_yet();

  else
    prints("Don't be a pyromaniac.");
}

/*----------------------------*/
do_evap()
{
  if (!ObjIsPresent(o_plasma))
    not_yet();

  else if (cmd.nn==o_fluid)
  {
    prints("The fluid evaporates.");
    JunkObj( cmd.nn );
  }

  else
    do_burn();
}

/*----------------------------*/
do_climb()
{
  if (cmd.nn==o_plant)
    prints("That isn't very polite, and besides, it's not a beanstalk.");

  else if (cmd.nn==o_mount)
    prints("There are no rivers on the mountain.");

  else
    not_poss();
}

/*----------------------------*/
do_cut()
{
  switch( cmd.nn )
  {
    case o_prism:
      prints("It's already pre-cut.");
      break;

    case o_tetra:
      prints("It is easily cut, but the cuts immediately reseal themselves.");
      break;

    case o_strip:
      prints("With some tricky cuts, you end up with a mobius strip again.");
      break;

    case o_bottle:
      prints("The bottle breaks into a mobius strip.");
      ReplaceObj( cmd.nn, o_strip );
      if (obj[o_liquid].loc==-8)
      {
        prints("The liquid in the bottle falls to the ground.");
        DropObj( o_liquid );
        if (curr_loc==obj[o_plant].loc)
        {
          cmd.nn=o_plant;
          do_water();
        }
      }
      break;

    case o_plant:
    case o_solid:
    case o_liquid:
      prints("Such low dimension cuts has no effect.");
      break;

    default:
      not_work();
  }
}

/*----------------------------*/
do_join()
{
  if (cmd.nn==o_group)
    prints("You're too finite.");
  else
    not_poss();
}

/*----------------------------*/
do_sing()
{
  if (curr_loc==obj[o_plant].loc)
    prints("Your singing can't possible compete with the hyper-melody.");

  else
    not_happen();
}

/*----------------------------*/
/*
*/
DoCommand()
{
  if (cmd.vn<=6
      || (cmd.vn>=39 && cmd.vn<=48) || cmd.vn==50 || cmd.vn==52
      || cmd.vn==58 )
    goto branch; /* single verbs */

  if (obj[cmd.nn].loc==-9)
  {
    prints("Be more specific in naming the object");
    return;
  }

  if (!ObjIsPresent(cmd.nn))
  {
    prints("That object is not here.");
    return;
  }

branch:
  switch ( cmd.vn )
  {
    case 1:
    case 2:
    case 3:
    case 4: do_dir(); break;
    case 5: do_inv(); break;
    case 6: do_go(); break;
    case 7: do_get(); break;
    case 8: do_drop(); break;
    case 9: do_throw(); break;
    case 10: do_break(); break;
    case 11: do_look(); break;
    case 12: do_read(); break;
    case 13: do_use(); break;
    case 14: do_touch(); break;
    case 15: do_swing(); break;
    case 16: do_rub(); break;
    case 17: do_push(); break;
    case 18: do_pop(); break;
    case 19: do_spin(); break;
    case 20: do_roll(); break;
    case 21: do_wear(); break;
    case 22: do_eat(); break;
    case 23: do_taste(); break;
    case 24: do_drink(); break;
    case 25: do_remove(); break;
    case 26: do_water(); break;
    case 27: do_fill(); break;
    case 28: do_pour(); break;
    case 29: do_freeze(); break;
    case 30: do_melt(); break;
    case 31: do_play(); break;
    case 32: do_insert(); break;
    case 33: do__y_(); break;
    case 34: do_prove(); break;
    case 35: do_fix(); break;
    case 36: do_smell(); break;
    case 37: do_close(); break;
    case 38: do_open();break;
    case 39: do_stop(); break;
    case 40: do_say(); break;
    case 41: do_quit(); break;
    case 42: do_help(); break;
    case 43: do_listen(); break;
    case 44: do_save(); break;
    case 45: do_load(); break;
    case 46: do_score(); break;
    case 47: do_sleep(); break;
    case 48: do_wake(); break;
    case 49: do_give(); break;
    case 50: do_scan(); break;
    case 51: do_solve(); break;
    case 52: do_think(); break;
    case 53: do_burn(); break;
    case 54: do_evap(); break;
    case 55: do_climb(); break;
    case 56: do_cut(); break;
    case 57: do_join(); break;
    case 58: do_sing(); break;
    default: cprintf( "I don't know how to %s.", cmd.verb );  nl();
  }
}

/*----------------------------*/
Ending( n )
  int n;
{
  switch ( n )
  {
    case 1:
      prints("Game Over");
      break;

    case 2:
      prints("Incorrect password.");
      prints("Self-destruct aborted.  Resuming Doomsday countdown.");
      prints("5\n4\n3\n2\n1\n\nEarth destro...");
      break;

    case 3:
      prints("Correct password.");
      prints
      ("Self-destruct sequence completed.  Overriding Doomsday countdown.");
      prints("5\n4\n3\n2\n1\n\nKaboom...");

      if (!ObjIsPresent(24))
      {
        prints("The Doomsday complex is destroyed.\n");
        prints("You have given your life to save Earth.  Thank you.");
      }
      else
      {
        prints(
        "As the complex disintegrates around you, the stack, sensing your\n");
        prints(
        "danger, overloads all it's circuits to regain a moment's control.\n");
        prints(
        "With a final burst of energy, the stack implodes, projecting a\n");
        prints(
        "stasis field around you that protects you from the destruction.\n");
        prints(
        "...\n");
        prints(
     "From the smoldering debris of the Doomsday complex you pick up the\n");
        prints(
        "pieces of the stack and reflect on how as you risked your life to\n");
        prints(
     "save Earth, the stack has given its own to save yours.  As you walk\n");
        prints(
        "away, you solemnly swear to repair the stack, for the adventures\n");
        prints(
        "that lie ahead.\n"
        );
      }
      break;
  }
}

/*----------------------------*/
/*
*/
intro1()
{
  prints(
"               /*--------------/*      ------------------------------------");
  prints(
"             /  '            /  '           Beyond The Tesseract   V2.0p");
  prints(
"           /   '|          /   '|      ------------------------------------");
  prints(
"        */----'---------*/    ' |          An abstract text adventure by");
  prints(
"       '|    '  |      '|    '  |            David Lo   4516 Albert St.");
  prints(
"      ' |   '   |     ' |   '   |                       Burnaby, B.C.");
  prints(
"     '  |  '   /*----'--|--'---/*                       V5C 2G5   Canada");
  prints(
"    '   | '  /  '   '   | '  /  '        email c/o: viola@idacom.cs.ubc.ca");
  prints(
"   '    |' /   '   '    |' /   '       ------------------------------------");
  prints(
"  '    /*/----'---'----/*/    '         This is FreeShareAnythingWare.");
  prints(
" '   /  '    '   '   /  '    '          If you like this program, hate it,");
  prints(
"'  /   '|   '   '  /   '|   '           or really don't care at all, then");
  prints(
"*/----'----'----*/    ' |  '            I would be happy to hear from you");
  prints(
"|    '  | '     |    '  | '             (a letter, a post-it note, etc).");
  prints(
"|   '   |'      |   '   |'");
  prints(
"|  '   /*-------|--'---/*               Please share unmodified copies of");
  prints(
"| '  /          | '  /                  this adventure with everyone.");
  prints(
"|' /            |' /                   ------------------------------------");
  prints(
"*/--------------*/                            'Set the software free'");
  prints("");
}

intro()
{
  int i,j,k;

  clrscr();
  intro1();
  prints("Press <Enter> to continue");
  i=get_enter();
  clrscr();

  prints("Scenario:");
  prints(
"  You have reached the final part of your mission.  You have gained access");
  prints(
"  to the complex, and all but the last procedure has been performed.  Now");
  prints(
"  comes a time of waiting, in which you must search for the hidden 12-word");
  prints(
"  message that will aid you at the final step.  But what choice will you");
  prints(
"  make when that time comes?");

  prints("");
  prints("Instructions:");
  prints(
"  This adventure recognizes the standard commands for moving (N,E,S,W),");
  prints(
"  taking inventory (I), maninpulating objects (GET, DROP, LOOK), and");
  prints(
"  saving games (SAVE, LOAD), as well as many others. Use 2-word 'verb noun'");
  prints(
"  commands, such as 'use stack' or 'get all'.  Only the first four letters");
  prints(
"  of each word are significant.  The adventure recognizes about 200 words,");
  prints(
"  so if one word doesn't work, try another.");

  prints("");
  prints("Happy adventuring!");
  prints("");

  prints("Press <Enter> to begin");
  j=get_enter();
  clrscr();
  srand( i*i + j + k );
}

/*------------------------------------------------------------*/
main()
{
  int i, keep_playing;

  intro();

  do
  {
    InitAdv();
    clrscr(); gotoxy( 1,25 );

    do
    {
      gp = InComplex(curr_loc) && (mi==15);

#ifdef tty
      if (print_room)
      {
        PrintCurrRoom();
        print_room=0;
      }
#endif

      if (gp)
        prints("A voice echoes: audio link complete.  Enter password.");

#ifndef tty
      PrintCurrRoom();
#endif

      if (InDreamWorld( curr_loc ))
        printf("(sleeping) ");
      else if (InBookWorld( curr_loc ))
        printf("(reading) ");

      cprintf("Enter command: ");
      getline( cmd.cm, max_cmd_size );
      if (cmd.cm[0])
      {
        AnalyseCommand( &cmd );
        DoCommand();
        nl();
      }
    }
    while ( !zap );

    Ending( zap );
    nl();
    cprintf("Play again (y/n)? ");
    getline( cmd.cm, max_cmd_size );
    keep_playing = (cmd.cm[0]!='n' && cmd.cm[0] !='N');
    nl();
  }
  while ( keep_playing );
  clrscr();
  intro1();
}

